/*
 * FoxconnReset.c
 *
 * Created: 26.01.2023 16:20:14
 * Author : -
 */ 

 #define F_CPU 1000000

#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>

volatile uint16_t TimerTicks = 0;

ISR(PCINT0_vect)
{
	TimerTicks = 0;
}

ISR(TIM0_OVF_vect)
{
	TCNT0 = -1000;
	TimerTicks++;
}

#define LED_ON PORTB|=(1<<PB2)
#define LED_OFF PORTB&=~(1<<PB2)

int main(void)
{
	DDRB = (1<<DDB2); // LED
	LED_OFF;
	
	TCCR0B = (1<<CS02) | (1<<CS00); // start, prescaler=1024
	TIMSK0 = (1<<TOIE0); // overflow int enable

/*
	while(1)
	{
	LED_OFF;
	_delay_ms(100);
	LED_ON;
	_delay_ms(200);
	}
*/

	// PB1      . HDD LED  -  
	TCNT0 = -1000;
	PCICR = (1<<PCIE0); // enable PCIE0 
	PCMSK = (1<<PCINT1); //   HDD LED

	sei();
    /* Replace with your application code */
    while (1) 
    {
		uint16_t i = 0;
		uint16_t TicksNow;

		cli();
		TicksNow = TimerTicks;
		sei();
		
		LED_ON;
		for(i=0; i<2; i++)
			_delay_ms(1);
		LED_OFF;
		if(TicksNow < 3) //   ,    
		{
			for(;i<200; i++)
			_delay_ms(1);
		LED_ON;
		for(; i<202; i++)
			_delay_ms(1);
		LED_OFF;
		}

		if(TicksNow > 110) //   
		{
			for(;i<200; i++)
				_delay_ms(1);
			LED_ON;
			for(; i<202; i++)
			_delay_ms(1);
			LED_OFF;
			for(; i<300; i++)
			_delay_ms(1);

			LED_ON;
			for(; i<302; i++)
			_delay_ms(1);
			LED_OFF;
			for(; i<400; i++)
			_delay_ms(1);

			LED_ON;
			for(; i<402; i++)
			_delay_ms(1);
			LED_OFF;
			for(; i<500; i++)
			_delay_ms(1);
		}

		for(;i<1000; i++)
			_delay_ms(1);

		if(TicksNow > 120)
		{
			cli();
			DDRB |= (1<<DDB0);
			PORTB = 0; //   

			uint8_t led = 0; //   4   
//  6    
			for(i=0;i<6000; i++)
			{
				_delay_ms(1);
				led++;
				if(led > 250 && (i < 1000 || i > 5000)) LED_ON;
				else LED_OFF;
			}

			DDRB &= ~(1<<DDB0); //  

//  8 
			for(i=0;i<2000; i++) //     
			{
				_delay_ms(4);
				led++;
				if(led > 254) LED_ON;
				else LED_OFF;
			}

			//  :    1 
			DDRB |= (1<<DDB0);
			for(i=0;i<1000; i++) //     
			{
				_delay_ms(1);
			}
			DDRB &= ~(1<<DDB0); //  

			TimerTicks = 0;
			sei();
		}
    }
}

